package book.beans;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.view.ViewScoped;
import javax.inject.Named;

/**
 *
 * @author Leonard
 */
@Named
@ViewScoped
public class PlayersBean implements Serializable {

    private List<Players> dataList = new ArrayList<>();
    private HtmlDataTable table;
    private int rowsOnPage;
    private String criteria = "all";
    private PlayersDataModel playersDataModel;
    final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");

    public PlayersBean() {
        rowsOnPage = 4;
        try {
            dataList.add(new Players(2, "NOVAK DJOKOVIC", (byte) 26, "Belgrad, Serbia", "Monte Carlo, Monako", (short) 188, (byte) 80, "Boris Becker, Marian Vajda", sdf.parse("22.05.1987")));
            dataList.add(new Players(1, "RAFAEL NADAL", (byte) 27, "Manacor, Majorka, Hiszpania", "Manacor, Majorka, Hiszpania", (short) 185, (byte) 85, "Toni Nadal", sdf.parse("03.06.1986")));
            dataList.add(new Players(7, "TOMAS BERDYCH", (byte) 28, "Valasske Mezirici, Czechy", "Monte Carlo, Monako", (short) 196, (byte) 91, "Tomas Krupa", sdf.parse("17.09.1985")));
            dataList.add(new Players(8, "STANISLAS WAWRINKA", (byte) 28, "Lozanna, Szwajcaria", "St. Barthelemy, Szwajcaria", (short) 183, (byte) 81, "Magnus Norman", sdf.parse("28.03.1985")));
            dataList.add(new Players(4, "ANDY MURRAY", (byte) 26, "Dunblane, Szkocja", "Londyn, Anglia", (short) 190, (byte) 84, "Ivan Lendl", sdf.parse("15.05.1987")));
            dataList.add(new Players(5, "JUAN MARTIN DEL POTRO", (byte) 25, "Tiil, Argentyna", "Tiil, Argentyna", (short) 198, (byte) 97, "Franco Davin", sdf.parse("23.09.1988")));
            dataList.add(new Players(10, "JO-WILFRIED TSONGA", (byte) 28, "Le Mans, Francja", "Gingins, Szwajcaria", (short) 188, (byte) 91, "Nicolas Escude i Thierry Ascione", sdf.parse("17.04.1985")));
            dataList.add(new Players(6, "ROGER FEDERER", (byte) 32, "Basel, Szwajcaria", "Bottmingen, Szwajcaria", (short) 185, (byte) 85, "Stefan Edberg, Severin Luthi", sdf.parse("08.08.1981")));
            dataList.add(new Players(9, "RICHARD GASQUET", (byte) 27, "Beziers, Francja", "Neuchatel, Szwajcaria", (short) 185, (byte) 75, "Sergi Bruguera i Sebastien Grosjean", sdf.parse("18.06.1986")));
            dataList.add(new Players(3, "DAVID FERRER", (byte) 31, "Javea, Hiszpania", "Walencja, Hiszpania", (short) 175, (byte) 73, "Jose Francisco Altur", sdf.parse("02.04.1982")));

            playersDataModel = new PlayersDataModel(dataList, dataList.size());
        } catch (ParseException ex) {
            Logger.getLogger(PlayersBean.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public PlayersDataModel getPlayersDataModel() {
        return playersDataModel;
    }

    public void setPlayersDataModel(PlayersDataModel playersDataModel) {
        this.playersDataModel = playersDataModel;
    }

    public String getCriteria() {
        return criteria;
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    public List<Players> getDataList() {
        return dataList;
    }

    public void setDataList(List<Players> dataList) {
        this.dataList = dataList;
    }

    public HtmlDataTable getTable() {
        return table;
    }

    public void setTable(HtmlDataTable table) {
        this.table = table;
    }

    public int getRowsOnPage() {
        return rowsOnPage;
    }

    public void setRowsOnPage(int rowsOnPage) {
        this.rowsOnPage = rowsOnPage;
    }

    public void goToFirstPage() {
        table.setRowClasses("rowshow");
        table.setFirst(0);
    }

    public void goToPreviousPage() {
        table.setRowClasses("rowshow");
        table.setFirst(table.getFirst() - table.getRows());
    }

    public void goToNextPage() {
        table.setFirst(table.getFirst() + table.getRows());
        if (!criteria.equals("all")) {
            cssFilter();
        }
    }

    public void goToLastPage() {

        int totalRows = table.getRowCount();
        int displayRows = table.getRows();
        int full = totalRows / displayRows;
        int modulo = totalRows % displayRows;

        if (modulo > 0) {
            table.setFirst(full * displayRows);
        } else {
            table.setFirst((full - 1) * displayRows);
        }
        if (!criteria.equals("all")) {
            cssFilter();
        }
    }

    public void addTableFilter() {
        
        table.setRowClasses("rowshow");
        playersDataModel.setRowCount(dataList.size());                
        int remaining = 0;

        Collections.sort(dataList, new Comparator<Players>() {
            @Override
            public int compare(Players key_1, Players key_2) {
                return key_1.getAge() - key_2.getAge();
            }
        });
        if (criteria.equals(">=26")) {
            Collections.reverse(dataList);
        }

        for (int i = 0; i < table.getRowCount(); i++) {
            table.setRowIndex(i);
            Players player = (Players) table.getRowData();
            if (criteria.equals("<26")) {
                if (player.getAge() >= 26) {
                    remaining++;
                }
            }
            if (criteria.equals(">=26")) {
                if (player.getAge() < 26) {
                    remaining++;
                }
            }
        }
        
        rowsOnPage = 4;
        if (rowsOnPage > (table.getRowCount() - remaining)) {
            rowsOnPage = table.getRowCount() - remaining;            
        }

        playersDataModel.setRowCount(table.getRowCount() - remaining);
        playersDataModel.setRowIndex(0);
        table.setFirst(0);
    }

    public void cssFilter() {
        String c = "";
        int remaining = 0;
        for (int i = (table.getFirst()); i < ((table.getFirst() + rowsOnPage) < table.getRowCount() ? (table.getFirst() + rowsOnPage) : table.getRowCount()); i++) {
            table.setRowIndex(i);
            Players player = (Players) table.getRowData();
            if (criteria.equals("<26")) {
                if (player.getAge() >= 26) {
                    c = c + "rowhide,";
                } else {
                    c = c + "rowshow,";
                    remaining++;
                }
            }
            if (criteria.equals(">=26")) {
                if (player.getAge() < 26) {
                    c = c + "rowhide,";
                } else {
                    c = c + "rowshow,";
                    remaining++;
                }
            }
        }

        while (remaining < rowsOnPage) {
            c = c + "rowhide,";
            remaining++;
        }
        String css = c.substring(0, c.length() - 1);
        table.setRowClasses(css);
    }
}
